﻿var objIdArray = ["beginCard", "endCard", "beginRfPort", "endRfPort", "beginChannel", "endChannel", "frequencyBeginValue", "frequencyChannelStep", "frequencyRfPortStep", "modulationMode", "symbolRate",
				  "tsId", "tsIdChannelStep", "tsIdPortStep", "qamManager", "qamGroup", "channelMode", "attenuation", "dtsAdjust", "sdvSupport", 
                  "sdvUdpBeginValue", "sdvUdpChannelStep", "sdvUdpPortStep"];
var defaultValueArray = ["0", "0", "--","--", "1","1", "500", "8", "0", "0", "6.875", "1", "1", "1", "0", "QG", "0", "0", "0", "0", "0", "0", "0"];
var FIRST_DELIMITER = ",";
var rfPortNumber = 0;
var portString = ["Port", "端口"];
var language;
var FrequencyMin = 48;
var FrequencyMax = 996;
var FreqDefaultVal = 500; 
var SymbolRateMin = 3.5;
var SymbolRateMax = 7.0;
var AttenMin = 0;
var AttenMax = 100;
var maxChannelNumber = 96;

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	getChannel();	
	
	document.body.style.cursor = "auto";
	window.status = "Done";
}

function pageRefresh()
{
	PageLoadHandler();
}

$(document).ready(function()
{
	var apply = document.getElementById("Apply");
	language = document.getElementById("language").value;
	applyDispay(parent.group, apply);
	PageLoadHandler();
});

function getChannel()
{
	var xmlhttp = false;
	var cnt = 0;
	xmlhttp = getHTTPObject();
	var params = "type=58&cmd=1&getAttrVal=0";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText;
			rfPortNumber = parseInt(response.slice(7, -8), 10);
			displayRfPort();
			resetDefault();
		}
	}
	xmlhttp.send(params);
	return false;
}

function displayRfPort()
{
	var $beginRfPort = $("#beginRfPort");
	var $endRfPort = $("#endRfPort");
	$beginRfPort.empty();
	$endRfPort.empty();
	for(var i = 0; i < rfPortNumber; i++)
	{
		$beginRfPort.append("<option value=" + i + ">RF " + portString[language] + (i + 1) +  "</option>");
		$endRfPort.append("<option value=" + i + ">RF " + portString[language] + (i + 1) + "</option>");
	}
}

function batchAddApply()
{
	var channelMode = $("#channelMode").val();
	if(paramCheck() == false)
	{
		return;
	}
	var getParams = "type=58&cmd=2&batchSetString=";
	getParams = getParams + generateData();
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Batch set successfully!");
			}
			else
			{
				alert("批量设置成功!");
			}
			var url;
			if(language == 0)
			{
				url = "main.asp?nodeId=22";
			}
			else
			{
				url = "main_cn.asp?nodeId=22";
			}
			window.parent.location.replace(url);
			//PageLoadHandler();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function generateData()
{
	var data;
	for(var i = 0,len = objIdArray.length; i < len; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	
	return data;
}

function resetDefault()
{
	for(var i = 0,len = objIdArray.length; i < len; i++)
	{
		if(defaultValueArray[i] != "--")
		{
			$("#" + objIdArray[i]).val(defaultValueArray[i]);
		}
		else
		{
			$("#" + objIdArray[i] + "option:first").prop("selected", true);
		}
	}
}
function checkFrequency(data)
{
	var patten  = /^\d+(\.\d+)?$/;
	if(!patten.test(data))
	{
		if(language == 0)
		{
			alert("Frequency should be a decimal number!");
		}
		else
		{
			alert("频率值应该为十进制数!");
		}
		return false;
	}
	if(validateFloat(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Frequency.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的频率值。");
		}
		return false;
	}
	if(validateAccuracy(data, 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Frequency is 3 digits.");
		}
		else
		{
			alert("频率值的有效性最多到小数点后三位。");
		}
		return false;
	}
	if((data < FrequencyMin)|| (data > FrequencyMax))
	{
		if(language == 0)
		{
			alert("Valid range for Frequency is " + FrequencyMin + " - " + FrequencyMax + " MHz.");
		}
		else
		{
			alert("频率值的有效范围是" + FrequencyMin + " - " + FrequencyMax + " MHz。");
		}
		return false;
	}
	return true;
}

function checkSymbolRate(data)
{
	var patten  = /^\d+(\.\d+)?$/;
	if(!patten.test(data))
	{
		if(language == 0)
		{
			alert("Symbol Rate should be a decimal number!");
		}
		else
		{
			alert("符号率值应该为十进制数!");
		}
		return false;
	}
	if(validateFloat(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Symbol Rate.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的符号率。");
		}
		return false;
	}
	if(validateAccuracy(data, 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Symbol Rate is 3 digits.");
		}
		else
		{
			alert("符号率的有效性最多到小数点后三位。");
		}
		return false;
	}
	if((data < SymbolRateMin)|| (data > SymbolRateMax))
	{
		if(language == 0)
		{
			alert("Valid range for Symbol Rate is " + SymbolRateMin + " - " + SymbolRateMax + " Mbaud.");
		}
		else
		{
			alert("符号率的有效范围是" + SymbolRateMin + " - " + SymbolRateMax + " Mbaud。");
		}
		return false;
	}
	return true;
}

function checkStartChannelNumber(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for start channel.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的起始频点值。");
		}
		return false;
	}
	if((data < 1) || (data > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for start channel is 1 - " + maxChannelNumber + ".");
		}
		else
		{
			alert("起始频点的范围是1 - " + maxChannelNumber + "。");
		}
		return false;
	}
	return true;
}

function checkEndChannelNumber(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for end channel.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的结束频点值。");
		}
		return false;
	}
	if((data < 1) || (data > maxChannelNumber))
	{
		if(language == 0)
		{
			alert("Valid range for end channel is 1 - " + maxChannelNumber + ".");
		}
		else
		{
			alert("结束频点的范围是1 - " + maxChannelNumber + "。");
		}
		return false;
	}
	return true;
}

function checkTranStrId(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Transport Stream ID.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的传输流ID。");
		}
		return false;
	}
	if((data < 0) || (data > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Transport Stream ID is 0 - 65535.");
		}
		else
		{
			alert("传输流ID的范围是0 - 65535。");
		}
		return false;
	}
	return true;
}

function checkAtten(data)
{
	if(validateFloat(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Atten.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的衰减值。");
		}
		return false;
	}
	if(validateAccuracy(data, 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Atten is 3 digits.");
		}
		else
		{
			alert("衰减的有效性最多到小数点后三位。");
		}
		return false;
	}
	if((data < AttenMin)|| (data > AttenMax))
	{
		if(language == 0)
		{
			alert("Valid range for Atten is " + AttenMin + " - " + AttenMax + ".");
		}
		else
		{
			alert("衰减的有效范围是" + AttenMin + " - " + AttenMax + "。");
		}
		return false;
	}
	return true;
}

function checkSdvUDP(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Starting UDP Port."); 
		}
		else
		{
			alert("无效的数字，请输入有效的动态UDP起始值。"); 
		}
		return false;
	}
	if((data < 0) || (data  > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Starting UDP Port is 0 - 65535.");
		}
		else
		{
			alert("动态UDP起始值的有效范围是0 - 65535。");
		}
		return false;
	}
	return true;
}

function paramCheck()
{
	if((parseInt($("#beginCard").val(), 10) >  parseInt($("#endCard").val(), 10)) || (parseInt($("#beginRfPort").val(), 10) >  parseInt($("#endRfPort").val(), 10)) || (parseInt($("#beginChannel").val(), 10) >  parseInt($("#endChannel").val(), 10)))
	{
		if(language == 0)
		{
			alert("The start of batch range must be smaller than the end!");
		}
		else
		{
			alert("批量范围的起始值必须小于结束值！");
		}
		return false;
	}
	var obj;
	obj = $("#beginChannel");	
	if(!checkStartChannelNumber(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#endChannel");	
	if(!checkEndChannelNumber(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#frequencyBeginValue");	
	if(!checkFrequency(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#symbolRate");	
	if(!checkSymbolRate(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#tsId");	
	if(!checkTranStrId(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#qamGroup");	
	if(validateName(obj.val(), 1, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#attenuation");	
	if(!checkAtten(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#sdvUdpBeginValue");	
	if(!checkSdvUDP(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}	
	//var curStartCard = $("#beginCard").val();
	//var curEndCard = $("#endCard").val();	
	var frequencyOffsetMax = FrequencyMax - parseInt($("#frequencyBeginValue").val(), 10);
	obj = $("#frequencyRfPortStep");
	if(validateFloat(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Frequency (RF Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的频率值(RF端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(validateAccuracy(obj.val(), 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Frequency Offset is 3 digits.");
		}
		else
		{
			alert("频率值(RF端口间增量)的有效性最多到小数点后三位。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((obj.val() < 0)|| (obj.val() > frequencyOffsetMax))
	{
		if(language == 0)
		{
			alert("Valid range for Frequency Offset is " + 0 + " - " + frequencyOffsetMax + " MHz.");
		}
		else
		{
			alert("频率值(RF端口间增量)的有效范围是" + 0 + " - " + frequencyOffsetMax + " MHz。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#tsIdChannelStep");
	var chOffsetTranStrId = obj.val();
	
	if(validateNumber(chOffsetTranStrId) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Transport Stream ID (Channel Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的传输流ID(频点间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	obj = $("#tsIdPortStep");
	var chOffsetTranStrId = obj.val();
	
	if(validateNumber(chOffsetTranStrId) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Transport Stream ID (RF Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的传输流ID(RF端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#sdvUdpChannelStep");
	var chOffsetUDP = obj.val();
	
	if(validateNumber(chOffsetUDP) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Starting UDP Port (Channel Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的动态UDP端口(频点间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((chOffsetUDP < 0) || (chOffsetUDP  > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Starting UDP Port (Channel Increment) is 0 - 65535.");
		}
		else
		{
			alert("动态UDP端口(频点间增量)的有效范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	obj = $("#sdvUdpPortStep");
	var chOffsetUDP = obj.val();
	
	if(validateNumber(chOffsetUDP) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Starting UDP Port (RF Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的动态UDP端口(RF端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((chOffsetUDP < 0) || (chOffsetUDP  > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Starting UDP Port (RF Port Increment) is 0 - 65535.");
		}
		else
		{
			alert("动态UDP端口(RF端口间增量)的有效范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
}